#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "oc_mqtt_command.h"
#include "oc_mqtt_profile.h"

void HandleMessageDown (EN_IOTA_MESSAGE *rsp) {
	if (rsp == NULL) {
		return;
	}
	printf("handle_demo HandleMessageDown(), content %s\n", rsp->content);
	printf("handle_demo HandleMessageDown(), id %s\n", rsp->id);
	printf("handle_demo HandleMessageDown(), name %s\n", rsp->name);
	printf("handle_demo HandleMessageDown(), object_device_id %s\n", rsp->object_device_id);
}

void HandlePropertiesSet (EN_IOTA_PROPERTY_SET *rsp) {
	if (rsp == NULL) {
		return;
	}
	printf("handle_demo HandlePropertiesSet(), messageId %d \n", rsp->mqtt_msg_info->messageId);
	printf("handle_demo HandlePropertiesSet(), request_id %s \n", rsp->request_id);
	printf("handle_demo HandlePropertiesSet(), object_device_id %s \n", rsp->object_device_id);

	int i = 0;
	while (rsp->services_count > 0) {
		printf("handle_demo HandlePropertiesSet(), service_id %s \n", rsp->services[i].service_id);
		printf("handle_demo HandlePropertiesSet(), properties %s \n", rsp->services[i].properties);
		rsp->services_count--;
		i++;
	}

	//响应平台
    oc_mqtt_profile_propertysetresp_t res = {0, "success", rsp->request_id};
	oc_mqtt_profile_propertysetresp(NULL, &res); //response
}

void HandlePropertiesGet (EN_IOTA_PROPERTY_GET *rsp) {
	if (rsp == NULL) {
		return;
	}
	printf("handle_demo HandlePropertiesSet(), messageId %d \n", rsp->mqtt_msg_info->messageId);
	printf("handle_demo HandlePropertiesSet(), request_id %s \n", rsp->request_id);
	printf("handle_demo HandlePropertiesSet(), object_device_id %s \n", rsp->object_device_id);

	printf("handle_demo HandlePropertiesSet(), service_id %s \n", rsp->service_id);

    //样例，返回数据
    ST_IOTA_SERVICE_DATA_INFO services[2] ={{"analog", NULL, "{\"PhV_phsA\":\"8\",\"PhV_phsB\":\"9\"}"},
                                            {"parameter", NULL, "{\"Load\":\"6\",\"ImbA_strVal\":\"7\"}"}};
    oc_mqtt_profile_propertyreport(NULL, services, 2);
}

void HandleCommandRequest(EN_IOTA_COMMAND *command) {

	if (command == NULL) {
		return;
	}

	printf("handle_demo HandleCommandRequest(), messageId %d\n", command->mqtt_msg_info->messageId);

	printf("handle_demo HandleCommandRequest(), object_device_id %s\n", command->object_device_id);
	printf("handle_demo HandleCommandRequest(), service_id %s\n", command->service_id);
	printf("handle_demo HandleCommandRequest(), command_name %s\n", command->command_name);
	printf("handle_demo HandleCommandRequest(), paras %s\n", command->paras);
	printf("handle_demo HandleCommandRequest(), request_id %s\n", command->request_id);
    
    oc_mqtt_profile_kv_t prp ={NULL, "SupWh", EN_OC_MQTT_PROFILE_VALUE_STRING, "aaa"};
    oc_mqtt_profile_cmdresp_t res = {0, "cmdResponses", command->request_id, &prp};
    oc_mqtt_profile_cmdresp(NULL, &res);
}
//
void HandleEventsDown(EN_IOTA_EVENT *message){

	if (message == NULL) {
		return;
	}

	printf("handle_demo HandleEventsDown(), messageId %d\n", message->mqtt_msg_info->messageId);
	printf("handle_demo HandleEventsDown(), services_count %d\n", message->services_count);
	printf("handle_demo HandleEventsDown(), object_device_id %s\n", message->object_device_id);
	int i = 0;
	while (message->services_count > 0) {
		printf("servie_id: %d \n", message->services[i].servie_id);
		printf("event_time: %s \n", message->services[i].event_time);
		printf("event_type: %d \n", message->services[i].event_type);

		//sub device manager
		if (message->services[i].servie_id == EN_IOTA_EVENT_SUB_DEVICE_MANAGER) {

			//if it is the platform inform the gateway to add or delete the sub device
			if(message->services[i].event_type == EN_IOTA_EVENT_ADD_SUB_DEVICE_NOTIFY || message->services[i].event_type == EN_IOTA_EVENT_DELETE_SUB_DEVICE_NOTIFY) {
				printf("version: %lld \n", message->services[i].paras->version);

				int j = 0;
				while(message->services[i].paras->devices_count > 0) {

					printf("handle_demo HandleEventsDown(), parent_device_id: %s \n", message->services[i].paras->devices[j].parent_device_id);
					printf("handle_demo HandleEventsDown(), device_id: %s \n", message->services[i].paras->devices[j].device_id);
					printf("handle_demo HandleEventsDown(), node_id: %s \n", message->services[i].paras->devices[j].node_id);

				    if (message->services[i].event_type == EN_IOTA_EVENT_DELETE_SUB_DEVICE_NOTIFY) {   //delete a sub device
						printf("handle_demo HandleEventsDown(), the sub device is deleted: %s\n", message->services[i].paras->devices[j].device_id);
					}

					j++;
					message->services[i].paras->devices_count--;
				}
			} else if (message->services[i].event_type == EN_IOTA_EVENT_ADD_SUB_DEVICE_RESPONSE) {
				int j = 0;
				while(message->services[i].gtw_add_device_paras->successful_devices_count > 0) {
					printf("handle_demo HandleEventsDown(), device_id: %s \n", message->services[i].gtw_add_device_paras->successful_devices[j].device_id);
					printf("handle_demo HandleEventsDown(), name: %s \n", message->services[i].gtw_add_device_paras->successful_devices[j].name);
					j++;
					message->services[i].gtw_add_device_paras->successful_devices_count--;
				}
				j = 0;
				while(message->services[i].gtw_add_device_paras->failed_devices_count > 0) {
					printf("handle_demo HandleEventsDown(), error_code: %s \n", message->services[i].gtw_add_device_paras->failed_devices[j].error_code);
					printf("handle_demo HandleEventsDown(), error_msg: %s \n", message->services[i].gtw_add_device_paras->failed_devices[j].error_msg);
					printf("handle_demo HandleEventsDown(), node_id: %s \n", message->services[i].gtw_add_device_paras->failed_devices[j].node_id);
					printf("handle_demo HandleEventsDown(), product_id: %s \n", message->services[i].gtw_add_device_paras->failed_devices[j].product_id);

					j++;
					message->services[i].gtw_add_device_paras->failed_devices_count--;
				}
			} else if (message->services[i].event_type == EN_IOTA_EVENT_DEL_SUB_DEVICE_RESPONSE) {
				int j = 0;
				while(message->services[i].gtw_del_device_paras->successful_devices_count > 0) {
					printf("handle_demo HandleEventsDown(), device_id: %s \n", message->services[i].gtw_del_device_paras->successful_devices[j]);
					j++;
					message->services[i].gtw_del_device_paras->successful_devices_count--;
				}
				j = 0;
				while(message->services[i].gtw_del_device_paras->failed_devices_count > 0) {
					printf("handle_demo HandleEventsDown(), error_code: %s \n", message->services[i].gtw_del_device_paras->failed_devices[j].error_code);
					printf("handle_demo HandleEventsDown(), error_msg: %s \n", message->services[i].gtw_del_device_paras->failed_devices[j].error_msg);
					printf("handle_demo HandleEventsDown(), device_id: %s \n", message->services[i].gtw_del_device_paras->failed_devices[j].device_id);

					j++;
					message->services[i].gtw_del_device_paras->failed_devices_count--;
				}
			}

		}else if (message->services[i].servie_id == EN_IOTA_EVENT_TIME_SYNC) {
			if(message->services[i].event_type == EN_IOTA_EVENT_GET_TIME_SYNC_RESPONSE) {
				printf("handle_demo HandleEventsDown(), device_real_time: %lld \n", message->services[i].ntp_paras->device_real_time);
			}
		} else if (message->services[i].servie_id == EN_IOTA_EVENT_DEVICE_LOG) {
			if(message->services[i].event_type == EN_IOTA_EVENT_LOG_CONFIG) {
				printf("handle_demo HandleEventsDown(), log_switch: %s \n", message->services[i].device_log_paras->log_switch);
				printf("handle_demo HandleEventsDown(), end_time: %s \n", message->services[i].device_log_paras->end_time);
			}
		}
		i++;
		message->services_count--;
	}
}

void SetMyCallbacks(){
    SetMessageCallback(HandleMessageDown);
	SetCmdCallback(HandleCommandRequest);
	SetPropSetCallback(HandlePropertiesSet);
	SetPropGetCallback(HandlePropertiesGet);
	SetEventCallback(HandleEventsDown);
}
	