/*Copyright (c) <2020>, <Huawei Technologies Co., Ltd>
 * All rights reserved.
 * &Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright notice, this list of
 * conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list
 * of conditions and the following disclaimer in the documentation and/or other materials
 * provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used
 * to endorse or promote products derived from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * */

#ifndef _OC_MQTT_COMM_H_
#define _OC_MQTT_COMM_H_

#include "stdarg.h"
#include "oc_mqtt_profile.h"
#if defined(WIN32) || defined(WIN64) && defined(EXPORT_AGENTLITE)
#define HW_API_FUNC __declspec(dllexport)
#else
#define HW_API_FUNC
#endif

typedef void (*PFN_CALLBACK_HANDLER)(void *context, int messageId, int code, char *message);
typedef void (*PFN_LOG_CALLBACK_HANDLER)(int level, char *format, va_list args);

void SetMyCallbacks();
/**
 * @param context: the application-self defined parameter, current is NULL
 * @param messageId: the inner messageId(1-65535) of the uplink message in this MQTT SDK
 * param code: the reason code for the failure callback
 */
typedef struct {
	void *context;
	int messageId;
	int code;
} EN_IOTA_MQTT_MSG_INFO;

typedef struct {
	char *parent_device_id;
	char *node_id;
	char *device_id;
	char *name;
	char *description;
	char *manufacturer_id;
	char *model;
	char *product_id;
	char *fw_version;
	char *sw_version;
	char *status;
	char *extension_info;
} EN_IOTA_DEVICE_INFO;

typedef struct {
	char *version;
	char *url;
	int file_size;
	char *access_token;
	int expires;
	char *sign;
} EN_IOTA_OTA_PARAS;

typedef struct {
	EN_IOTA_DEVICE_INFO *devices;
	int devices_count;
	long long version;
} EN_IOTA_DEVICE_PARAS;

typedef struct {
	long long device_real_time;
} EN_IOTA_NTP_PARAS;

typedef struct {
	char *node_id;
	char *product_id;
	char *error_code;
	char *error_msg;
} EN_IOTA_ADD_DEVICE_FAILED_REASON;

typedef struct {
	EN_IOTA_DEVICE_INFO *successful_devices;
	int successful_devices_count;
	EN_IOTA_ADD_DEVICE_FAILED_REASON *failed_devices;
	int failed_devices_count;
} EN_IOTA_GTW_ADD_DEVICE_PARAS;

typedef struct {
	char *device_id;
	char *error_code;
	char *error_msg;
} EN_IOTA_DEL_DEVICE_FAILED_REASON;

typedef struct {
	char **successful_devices;
	int successful_devices_count;
	EN_IOTA_DEL_DEVICE_FAILED_REASON *failed_devices;
	int failed_devices_count;
} EN_IOTA_GTW_DEL_DEVICE_PARAS;

typedef struct {
	char *log_switch;
	char *end_time;
} EN_IOTA_DEVICE_LOG_PARAS;

typedef struct {
	int servie_id;  //see the enum EN_IOTA_EVENT_SERVICE_ID
	int event_type;  //see the enum EN_IOTA_EVENT_TYPE
	char *event_time;
	char *event_id;
	EN_IOTA_DEVICE_PARAS *paras;
	EN_IOTA_OTA_PARAS *ota_paras;
	EN_IOTA_NTP_PARAS *ntp_paras;
	EN_IOTA_GTW_ADD_DEVICE_PARAS *gtw_add_device_paras;
	EN_IOTA_GTW_DEL_DEVICE_PARAS *gtw_del_device_paras;
	EN_IOTA_DEVICE_LOG_PARAS *device_log_paras;
} EN_IOTA_SERVICE_EVENT;

typedef struct {
	EN_IOTA_MQTT_MSG_INFO *mqtt_msg_info;
	char *object_device_id;
	EN_IOTA_SERVICE_EVENT *services;
    int services_count;
} EN_IOTA_EVENT;

typedef struct {
	EN_IOTA_MQTT_MSG_INFO *mqtt_msg_info;
	char *object_device_id;
	char *service_id;
	char *command_name;
	char *paras;
	char *request_id;
} EN_IOTA_COMMAND;

typedef struct {
	EN_IOTA_MQTT_MSG_INFO *mqtt_msg_info;
	char *msgType;
	char *serviceId;
	char *cmd;
	char *paras;
	int mid;
} EN_IOTA_COMMAND_V3;

typedef struct {
	EN_IOTA_MQTT_MSG_INFO *mqtt_msg_info;
	char *message;
} EN_IOTA_MQTT_PROTOCOL_RSP;

typedef struct {
	EN_IOTA_MQTT_MSG_INFO *mqtt_msg_info;
	char *object_device_id;
	char *name;
	char *id;
	char *content;
} EN_IOTA_MESSAGE;

typedef struct {
	char *service_id;
	char *properties;
} EN_IOTA_SERVICE_PROPERTY;

typedef struct {
	EN_IOTA_MQTT_MSG_INFO *mqtt_msg_info;
	char *object_device_id;
	char *request_id;
	EN_IOTA_SERVICE_PROPERTY *services;
	int services_count;
} EN_IOTA_PROPERTY_SET;

typedef struct {
	EN_IOTA_MQTT_MSG_INFO *mqtt_msg_info;
	char *object_device_id;
	char *request_id;
	char *service_id;
} EN_IOTA_PROPERTY_GET;

typedef struct {
	char *service_id;
	char *desired_event_time;
	char *desired_properties;
	char *reported_event_time;
	char *reported_properties;
	int version;
} EN_IOTA_SHADOW_DATA;

typedef struct {
	EN_IOTA_MQTT_MSG_INFO *mqtt_msg_info;
	char *object_device_id;
	char *request_id;
	EN_IOTA_SHADOW_DATA *shadow;
	int shadow_data_count;
} EN_IOTA_DEVICE_SHADOW;

typedef struct {
	EN_IOTA_MQTT_MSG_INFO *mqtt_msg_info;
	char *object_device_id;
	char *name;
	char *id;
	char *content;
	char *topic_para;
} EN_IOTA_USER_TOPIC_MESSAGE;

int oc_mqtt_profile_rcvdeal(oc_mqtt_profile_msgrcv_t *payload);
typedef enum {
	EN_IOTA_EVENT_SUB_DEVICE_MANAGER = 0,
	EN_IOTA_EVENT_OTA = 1,
	EN_IOTA_EVENT_TIME_SYNC = 2,
	EN_IOTA_EVENT_DEVICE_LOG = 3,
//	EN_IOTA_EVENT_FILE_MANAGER = 4,
//	EN_IOTA_EVENT_SDK_INFO = 5,
	EN_IOTA_EVENT_ERROR = -1
} EN_IOTA_EVENT_SERVICE_ID;

typedef enum {
	EN_IOTA_EVENT_ADD_SUB_DEVICE_NOTIFY = 0,
	EN_IOTA_EVENT_DELETE_SUB_DEVICE_NOTIFY = 1,
	EN_IOTA_EVENT_VERSION_QUERY = 2,
	EN_IOTA_EVENT_FIRMWARE_UPGRADE = 3,
	EN_IOTA_EVENT_SOFTWARE_UPGRADE = 4,
	EN_IOTA_EVENT_GET_TIME_SYNC_RESPONSE = 5,
	EN_IOTA_EVENT_ADD_SUB_DEVICE_RESPONSE = 6,
	EN_IOTA_EVENT_DEL_SUB_DEVICE_RESPONSE = 7,
	EN_IOTA_EVENT_LOG_CONFIG = 8,
//	EN_IOTA_EVENT_GET_UPLOAD_URL_RESPONSE = 9,
//	EN_IOTA_EVENT_GET_DOWNLOAD_URL_RESPONSE = 10,
	EN_IOTA_EVENT_TYPE_ERROR = -1
} EN_IOTA_EVENT_TYPE;

typedef void (*LOG_CALLBACK_HANDLER)(int level, char *format, va_list args);

#define MAX_EVENT_COUNT 3
#define MAX_EVENT_DEVICE_COUNT 10
#define MAX_SERVICE_COUNT 50

void OnLoginSuccess(EN_IOTA_MQTT_PROTOCOL_RSP *rsp);
void OnMessageArrived(void *context, int token, int code, const char *topic, char *message);

typedef void (*EVENT_CALLBACK_HANDLER)(EN_IOTA_EVENT *message);
int SetEventCallback(EVENT_CALLBACK_HANDLER pfnCallbackHandler);

typedef void (*CMD_CALLBACK_HANDLER)(EN_IOTA_COMMAND *message);
int SetCmdCallback(CMD_CALLBACK_HANDLER pfnCallbackHandler);

typedef void (*PROTOCOL_CALLBACK_HANDLER)(EN_IOTA_MQTT_PROTOCOL_RSP *protocolRsp);
int SetProtocolCallback(int item, PROTOCOL_CALLBACK_HANDLER pfnCallbackHandler);

typedef void (*MESSAGE_CALLBACK_HANDLER)(EN_IOTA_MESSAGE *protocolRsp);
int SetMessageCallback(MESSAGE_CALLBACK_HANDLER pfnCallbackHandler);

typedef void (*PROP_SET_CALLBACK_HANDLER)(EN_IOTA_PROPERTY_SET *rsp);
int SetPropSetCallback(PROP_SET_CALLBACK_HANDLER pfnCallbackHandler);

typedef void (*PROP_GET_CALLBACK_HANDLER)(EN_IOTA_PROPERTY_GET *rsp);
int SetPropGetCallback(PROP_GET_CALLBACK_HANDLER pfnCallbackHandler);

typedef void (*BOOTSTRAP_CALLBACK_HANDLER)(EN_IOTA_MQTT_PROTOCOL_RSP *rsp);
int SetBootstrapCallback(BOOTSTRAP_CALLBACK_HANDLER pfnCallbackHandler);

#define SERVICES      			 	 "services"
#define DEVICES      			 	 "devices"
#define RESULT_CODE      			 "result_code"
#define RESULT      			 	 "result"
#define TARGET_DEVICE_ID      		 "target_device_id"
#define DEVICE_ID       			 "device_id"
#define SERVICE_ID       			 "service_id"
#define EVENT_TIME      			 "event_time"
#define EVENT_ID					 "event_id"
#define PROPERTIES      			 "properties"
#define RESPONSE_NAME      			 "response_name"
#define PARAS  	    			 	 "paras"
#define RESULT_DESC      			 "result_desc"
#define CONTENT      				 "content"
#define ID      					 "id"
#define NAME	      				 "name"
#define OBJECT_DEVICE_ID      		 "object_device_id"
#define EVENT_TYPE      			 "event_type"
#define VERSION_REPORT      	     "version_report"
#define UPGRADE_PROGRESS_REPORT      "upgrade_progress_report"
#define SW_VERSION                   "sw_version"
#define FW_VERSION                   "fw_version"
#define PROGRESS                     "progress"
#define DESCRIPTION                  "description"
#define OBJECT_DEVICE_ID             "object_device_id"
#define OTA                          "$ota"
#define VERSION                      "version"
#define SERVICE_ID					 "service_id"
#define SUB_DEVICE_MANAGER			 "$sub_device_manager"
#define ADD_SUB_DEVICE_NOTIFY		 "add_sub_device_notify"
#define PARENT_DEVICE_ID 			 "parent_device_id"
#define NODE_ID 					 "node_id"
#define MANUFACTURER_ID				 "manufacturer_id"
#define MODEL					     "model"
#define PRODUCT_ID					 "product_id"
#define FW_VERSION					 "fw_version"
#define SW_VERSION					 "sw_version"
#define EXTENSION_INFO				 "extension_info"
#define STATUS					     "status"
#define DELETE_SUB_DEVICE_NOTIFY	 "delete_sub_device_notify"
#define ADD_SUB_DEVICE_RESPONSE		 "add_sub_device_response"
#define DEL_SUB_DEVICE_RESPONSE		 "delete_sub_device_response"
#define SUCCESSFUL_DEVICES			 "successful_devices"
#define FAILED_DEVICES				 "failed_devices"
#define ERROR_CODE					 "error_code"
#define ERROR_MSG					 "error_msg"
#define FIRMWARE_UPGRADE			 "firmware_upgrade"
#define SOFTWARE_UPGRADE			 "software_upgrade"
#define URL							 "url"
#define FILE_SIZE					 "file_size"
#define ACCESS_TOKEN				 "access_token"
#define EXPIRES						 "expires"
#define SIGN						 "sign"
#define DATA_V3						 "data"
#define SERVICE_ID_V3				 "serviceId"
#define EVENT_TIME_V3      			 "eventTime"
#define SERVICE_DATA_V3      		 "serviceData"
#define MSGTYPE						 "msgType"
#define DEVIVE_REQ					 "deviceReq"
#define CMD							 "cmd"
#define MID							 "mid"
#define ERR_CODE					 "errcode"
#define BODY						 "body"
#define DEVIVE_RSP					 "deviceRsp"
#define VERSION_QUERY				 "version_query"
#define COMMAND_NAME 				 "command_name"
#define SHADOW						 "shadow"
#define DESIRED						 "desired"
#define REPORTED					 "reported"
#define SDK_INFO					 "$sdk_info"
#define SDK_INFO_REPORT				 "sdk_info_report"
#define TYPE						 "type"
#define SDK_LANGUAGE				 "C"
#define SDK_TIME					 "$time_sync"
#define SDK_NTP_REQUEST				 "time_sync_request"
#define DEVICE_SEND_TIME			 "device_send_time"
#define TIME_SYNC_RSP				 "time_sync_response"
#define SERVER_RECV_TIME			 "server_recv_time"
#define SERVER_SEND_TIME			 "server_send_time"
#define VERSION_JSON				 "\"version\""
#define DEVICE_SEND_TIME_JSON		 "\"device_send_time\""
#define SERVER_RECV_TIME_JSON		 "\"server_recv_time\""
#define SERVER_SEND_TIME_JSON		 "\"server_send_time\""
#define LOG							 "$log"
#define LOG_CONFIG					 "log_config"
#define SWITCH						 "switch"
#define END_TIME					 "end_time"
#define LOG_REPORT					 "log_report"
#define ADDRESS						 "address"

#endif




