
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "cJSON.h"
#include "oc_mqtt_command.h"
#include "json_util.h"
#include "string_util.h"


EVENT_CALLBACK_HANDLER onEventDown; //
CMD_CALLBACK_HANDLER onCmd;      //
MESSAGE_CALLBACK_HANDLER onMessage;   //
PROP_SET_CALLBACK_HANDLER onPropertiesSet; //
PROP_GET_CALLBACK_HANDLER onPropertiesGet; //
BOOTSTRAP_CALLBACK_HANDLER onBootstrap; //

int oc_mqtt_comm_msgdown(void *context, int token, int code, char *message){

    printf("oc_mqtt_comm_msgdown c JSON data processing\n");
    EN_IOTA_MESSAGE *msg  = (EN_IOTA_MESSAGE*)malloc(sizeof(EN_IOTA_MESSAGE));
		if (msg == NULL) {
			printf( "OnMessageArrived(): there is not enough memory here.\n");
			return -1;
		}
		msg->mqtt_msg_info = (EN_IOTA_MQTT_MSG_INFO*)malloc(sizeof(EN_IOTA_MQTT_MSG_INFO));
		if (msg->mqtt_msg_info == NULL) {
			printf( "OnMessageArrived(): there is not enough memory here.\n");
			free(msg);
			return -1;
		}
		msg->mqtt_msg_info->context = context;
		msg->mqtt_msg_info->messageId = token;
		msg->mqtt_msg_info->code = code;

        
		 JSON *root = JSON_Parse(message);

		char *object_device_id = JSON_GetStringFromObject(root, OBJECT_DEVICE_ID, "-1");
		msg->object_device_id = object_device_id;

		char *name = JSON_GetStringFromObject(root, NAME, "-1");
		msg->name = name;

		char *id = JSON_GetStringFromObject(root, ID, "-1");
		msg->id = id;

		char *content = JSON_GetStringFromObject(root, CONTENT, "-1");
		msg->content = content;

		if (onMessage) {
			(onMessage)(msg);
		}
        printf("msg->object_device_id  = %s\n", msg->object_device_id);
        printf("msg->name= %s\n", msg->name );
        printf("msg->id = %s\n", msg->id);
        printf("msg->content = %s\n", msg->content);

		JSON_Delete(root);
		MemFree(&msg->mqtt_msg_info);
		MemFree(&msg);
		return 0;
}

int oc_mqtt_comm_commands(void *context, int token, int code, const char *request_id, char *message){

		EN_IOTA_COMMAND *command  = (EN_IOTA_COMMAND*)malloc(sizeof(EN_IOTA_COMMAND));
		if (command == NULL) {
			printf( "there is not enough memory here.\n");
			return -1;
		}

		command->mqtt_msg_info = (EN_IOTA_MQTT_MSG_INFO*)malloc(sizeof(EN_IOTA_MQTT_MSG_INFO));
		if (command->mqtt_msg_info == NULL) {
			printf( "there is not enough memory here.\n");
			free(command);
			return -1;
		}
		command->mqtt_msg_info->context = context;
		command->mqtt_msg_info->messageId = token;
		command->mqtt_msg_info->code = code;

		command->request_id = request_id;

		 JSON *root = JSON_Parse(message);

		char *object_device_id = JSON_GetStringFromObject(root, OBJECT_DEVICE_ID, "-1");           //get value of object_device_id
		command->object_device_id = object_device_id;

		char *service_id = JSON_GetStringFromObject(root, SERVICE_ID, "-1");     //get value of service_id
		command->service_id = service_id;

		char *command_name = JSON_GetStringFromObject(root, COMMAND_NAME, "-1");     //get value of command_name
		command->command_name = command_name;

		 JSON *paras = JSON_GetObjectFromObject(root, PARAS);       //get value of data

		char *paras_obj =  JSON_Print(paras);
		command->paras = paras_obj;
        printf("object_device_id = %s\n", object_device_id);
        printf("service_id = %s\n", service_id);
        printf("command_name = %s\n", command_name);
        printf("paras_obj = %s\n", paras_obj);

		if (onCmd) {
			(onCmd)(command);
		}

		JSON_Delete(root);
		MemFree(&paras_obj);
		MemFree(&command->mqtt_msg_info);
		MemFree(&command);

		return 0;

}
int oc_mqtt_comm_propertyset(void *context, int token, int code, const char *request_id, char *message){

		EN_IOTA_PROPERTY_SET *prop_set = (EN_IOTA_PROPERTY_SET*)malloc(sizeof(EN_IOTA_PROPERTY_SET));
		if (prop_set == NULL) {
			printf( "there is not enough memory here.\n");
			return -1;
		}

		prop_set->mqtt_msg_info = (EN_IOTA_MQTT_MSG_INFO*)malloc(sizeof(EN_IOTA_MQTT_MSG_INFO));
		if (prop_set->mqtt_msg_info == NULL) {
			printf( "there is not enough memory here.\n");
			free(prop_set);
			return -1;
		}
		prop_set->mqtt_msg_info->context = context;
		prop_set->mqtt_msg_info->messageId = token;
		prop_set->mqtt_msg_info->code = code;

		prop_set->request_id = request_id;

		 JSON *root = JSON_Parse(message);

		char *object_device_id = JSON_GetStringFromObject(root, OBJECT_DEVICE_ID, "-1");     //get value of object_device_id
		prop_set->object_device_id = object_device_id;

		 JSON *services = JSON_GetObjectFromObject(root, SERVICES);                            //get  services array

		int services_count = JSON_GetArraySize(services);                                            //get length of services array
		prop_set->services_count = services_count;


		if (services_count >= MAX_SERVICE_COUNT) {
			printf( "the number of service exceeds.\n");
			JSON_Delete(root);
			free(prop_set->mqtt_msg_info);
			free(prop_set);
			return -1;
		}

		prop_set->services = (EN_IOTA_SERVICE_PROPERTY*)malloc(sizeof(EN_IOTA_SERVICE_PROPERTY) * services_count);
		if (prop_set->services == NULL) {
			printf( "there is not enough memory here.\n");
			JSON_Delete(root);
			free(prop_set->mqtt_msg_info);
			free(prop_set);
			return -1;
		}

		int i = 0;
		char *prop[MAX_SERVICE_COUNT]= {0};
		while (services_count > 0) {
			 JSON *service = JSON_GetObjectFromArray(services, i);
			if (service) {
				char *service_id = JSON_GetStringFromObject(service, SERVICE_ID, NULL);
				prop_set->services[i].service_id = service_id;

				 JSON *properties = JSON_GetObjectFromObject(service, PROPERTIES);
				prop[i] =  JSON_Print(properties);
				prop_set->services[i].properties = prop[i];

			}

			i++;
			services_count--;
		}

		if (onPropertiesSet) {
			(onPropertiesSet)(prop_set);
		}

		JSON_Delete(root);
		int j;
		for (j = 0;j < i;j++) {
			MemFree(&prop[j]);
		}
		MemFree(&prop);
		MemFree(&prop_set->services);
		MemFree(&prop_set->mqtt_msg_info);
		MemFree(&prop_set);

		return 0;
}
int oc_mqtt_comm_propertyget(void *context, int token, int code, const char *request_id, char *message){

		EN_IOTA_PROPERTY_GET *prop_get = (EN_IOTA_PROPERTY_GET*)malloc(sizeof(EN_IOTA_PROPERTY_GET));
		if (prop_get == NULL) {
			printf( "there is not enough memory here.\n");
			return -1;
		}

		prop_get->mqtt_msg_info = (EN_IOTA_MQTT_MSG_INFO*)malloc(sizeof(EN_IOTA_MQTT_MSG_INFO));
		if (prop_get->mqtt_msg_info == NULL) {
			printf( "there is not enough memory here.\n");
			free(prop_get);
			return -1;
		}
		prop_get->mqtt_msg_info->context = context;
		prop_get->mqtt_msg_info->messageId = token;
		prop_get->mqtt_msg_info->code = code;

		prop_get->request_id = request_id;

		 JSON *root = JSON_Parse(message);

		char *object_device_id = JSON_GetStringFromObject(root, OBJECT_DEVICE_ID, "-1");     //get value of object_device_id
		prop_get->object_device_id = object_device_id;

		char *service_id = JSON_GetStringFromObject(root, SERVICE_ID, "-1");     //get value of object_device_id
		prop_get->service_id = service_id;
        if(object_device_id != NULL)
            printf("object_device_id = %s\n",object_device_id);
        printf("prop_get->service_id = %s\n", prop_get->service_id);
		if (onPropertiesGet) {
			(onPropertiesGet)(prop_get);
		}

		JSON_Delete(root);
		MemFree(&prop_get->mqtt_msg_info);
		MemFree(&prop_get);
		return 0;
}
int oc_mqtt_comm_event(void *context, int token, int code, char *message){
EN_IOTA_EVENT *event = (EN_IOTA_EVENT*)malloc(sizeof(EN_IOTA_EVENT));
		if (event == NULL) {
			printf( "there is not enough memory here.\n");
			return -1;
		}

		event->mqtt_msg_info = (EN_IOTA_MQTT_MSG_INFO*)malloc(sizeof(EN_IOTA_MQTT_MSG_INFO));
		if (event->mqtt_msg_info == NULL) {
			printf( "there is not enough memory here.\n");
			free(event);
			return -1;
		}
		event->mqtt_msg_info->context = context;
		event->mqtt_msg_info->messageId = token;
		event->mqtt_msg_info->code = code;


		 JSON *root = JSON_Parse(message);

		char *object_device_id = JSON_GetStringFromObject(root, OBJECT_DEVICE_ID, "-1");           //get value of object_device_id
		event->object_device_id = object_device_id;

		 JSON *services = JSON_GetObjectFromObject(root, SERVICES);                                 //get object of services

		int services_count = 0;
		services_count = JSON_GetArraySize(services);                                                 //get size of services

		if (services_count > MAX_EVENT_COUNT) {
			printf( "messageArrivaled: services_count is too large.\n"); //you can increase the MAX_EVENT_COUNT in iota_init.h
			JSON_Delete(root);
			MemFree(&event);
			return -1;
		}

		event->services_count = services_count;
		event->services = (EN_IOTA_SERVICE_EVENT*)malloc(sizeof(EN_IOTA_SERVICE_EVENT) * services_count);
		if (event->services == NULL) {
			printf( "there is not enough memory here.\n");
			free(event->mqtt_msg_info);
			free(event);
			return -1;
		}

		int services_count_copy = services_count;  // for releasing the services

		int i = 0;
		while(services_count > 0) {
			 JSON *serviceEvent = JSON_GetObjectFromArray(services, i);                              //get object of ServiceEvent
			if (serviceEvent) {
				char *service_id = JSON_GetStringFromObject(serviceEvent, SERVICE_ID, NULL);    //get value of service_id
				event->services[i].servie_id = EN_IOTA_EVENT_ERROR;  //init service id

				char *event_type = NULL; //To determine whether to add or delete a sub device
				event_type = JSON_GetStringFromObject(serviceEvent, EVENT_TYPE, NULL);    //get value of event_type
				event->services[i].event_type = EN_IOTA_EVENT_TYPE_ERROR; //init event type

				char *event_time = JSON_GetStringFromObject(serviceEvent, EVENT_TIME, NULL);    //get value of event_time
				event->services[i].event_time = event_time;

				 JSON *paras = JSON_GetObjectFromObject(serviceEvent, PARAS);                    //get object of paras

				//sub device manager
				if (!strcmp(service_id, SUB_DEVICE_MANAGER)) {

					event->services[i].servie_id = EN_IOTA_EVENT_SUB_DEVICE_MANAGER;

					//if it is the platform inform the gateway to add or delete the sub device
					if(!strcmp(event_type, DELETE_SUB_DEVICE_NOTIFY) || !strcmp(event_type, ADD_SUB_DEVICE_NOTIFY)) {
						event->services[i].paras = (EN_IOTA_DEVICE_PARAS*)malloc(sizeof(EN_IOTA_DEVICE_PARAS));
						if (event->services[i].paras == NULL) {
							printf( "HandleEventsDown(): there is not enough memory here.\n");
							free(event->services);
							free(event->mqtt_msg_info);
							free(event);
							return -1;
						}

						 JSON *devices = JSON_GetObjectFromObject(paras, DEVICES);                                 //get object of devices

						int devices_count = JSON_GetArraySize(devices);                                                 //get size of devicesSize

						if (devices_count > MAX_EVENT_DEVICE_COUNT) {
							printf( "messageArrivaled: HandleEventsDown(), devices_count is too large.\n"); //you can increase the MAX_EVENT_DEVICE_COUNT in iota_init.h
//							JSON_Delete(root);
							break;
						}

						event->services[i].paras->devices = (EN_IOTA_DEVICE_INFO*)malloc(sizeof(EN_IOTA_DEVICE_INFO) * devices_count);
						if (event->services[i].paras == NULL) {
							printf( "HandleEventsDown(): there is not enough memory here.\n");
							while(i >= 0) {
								free(event->services[i].paras);
								i--;
							}
							free(event->services);
							free(event->mqtt_msg_info);
							free(event);
							return -1;
						}

						event->services[i].paras->devices_count = devices_count;

						long long version = getLLongValueFromStr(message, VERSION_JSON);
						event->services[i].paras->version = version;
						int j = 0;

						//adding a sub device notify
						if (!strcmp(event_type, ADD_SUB_DEVICE_NOTIFY)) {
							event->services[i].event_type = EN_IOTA_EVENT_ADD_SUB_DEVICE_NOTIFY;
							while(devices_count > 0) {
								 JSON *deviceInfo = JSON_GetObjectFromArray(devices, j);                                 //get object of deviceInfo

								char *parent_device_id = JSON_GetStringFromObject(deviceInfo, PARENT_DEVICE_ID, NULL);    //get value of parent_device_id
								event->services[i].paras->devices[j].parent_device_id = parent_device_id;

								char *node_id = JSON_GetStringFromObject(deviceInfo, NODE_ID, NULL);    //get value of node_id
								event->services[i].paras->devices[j].node_id = node_id;

								char *device_id = JSON_GetStringFromObject(deviceInfo, DEVICE_ID, NULL);    //get value of device_id
								event->services[i].paras->devices[j].device_id = device_id;

								char *name = JSON_GetStringFromObject(deviceInfo, NAME, NULL);    //get value of name
								event->services[i].paras->devices[j].name = name;

								char *description = JSON_GetStringFromObject(deviceInfo, DESCRIPTION, NULL);    //get value of description
								event->services[i].paras->devices[j].description = description;

								char *manufacturer_id = JSON_GetStringFromObject(deviceInfo, MANUFACTURER_ID, NULL);    //get value of manufacturer_id
								event->services[i].paras->devices[j].manufacturer_id = manufacturer_id;

								char *model = JSON_GetStringFromObject(deviceInfo, MODEL, NULL);    //get value of model
								event->services[i].paras->devices[j].model = model;

								char *product_id = JSON_GetStringFromObject(deviceInfo, PRODUCT_ID, NULL);    //get value of product_id
								event->services[i].paras->devices[j].product_id = product_id;

								char *fw_version = JSON_GetStringFromObject(deviceInfo, FW_VERSION, NULL);    //get value of fw_version
								event->services[i].paras->devices[j].fw_version = fw_version;

								char *sw_version = JSON_GetStringFromObject(deviceInfo, SW_VERSION, NULL);    //get value of sw_version
								event->services[i].paras->devices[j].sw_version = sw_version;

								char *status = JSON_GetStringFromObject(deviceInfo, STATUS, NULL);    //get value of status
								event->services[i].paras->devices[j].status = status;

								char *extension_info = JSON_GetStringFromObject(deviceInfo, EXTENSION_INFO, NULL);    //get value of status
								event->services[i].paras->devices[j].extension_info = extension_info;

								j++;
								devices_count--;
							}
						}

						//deleting a sub device notify
						if (!strcmp(event_type, DELETE_SUB_DEVICE_NOTIFY)) {
							event->services[i].event_type = EN_IOTA_EVENT_DELETE_SUB_DEVICE_NOTIFY;
							while(devices_count > 0) {
								 JSON *deviceInfo = JSON_GetObjectFromArray(devices, j);                                 //get object of deviceInfo

								char *parent_device_id = JSON_GetStringFromObject(deviceInfo, PARENT_DEVICE_ID, NULL);    //get value of parent_device_id
								event->services[i].paras->devices[j].parent_device_id = parent_device_id;

								char *node_id = JSON_GetStringFromObject(deviceInfo, NODE_ID, NULL);    //get value of node_id
								event->services[i].paras->devices[j].node_id = node_id;

								char *device_id = JSON_GetStringFromObject(deviceInfo, DEVICE_ID, NULL);    //get value of device_id
								event->services[i].paras->devices[j].device_id = device_id;

								j++;
								devices_count--;

							}
						}
					}

					//the response of gateway adding a sub device
					if(!strcmp(event_type, ADD_SUB_DEVICE_RESPONSE)) {

						char *event_id = JSON_GetStringFromObject(serviceEvent, EVENT_ID, NULL);    //get value of event_id
						event->services[i].event_id = event_id;
						event->services[i].event_type = EN_IOTA_EVENT_ADD_SUB_DEVICE_RESPONSE;

						event->services[i].gtw_add_device_paras = (EN_IOTA_GTW_ADD_DEVICE_PARAS*)malloc(sizeof(EN_IOTA_GTW_ADD_DEVICE_PARAS));
						if(event->services[i].gtw_add_device_paras == NULL) {
							printf( "HandleEventsDown(): there is not enough memory here.\n");
							free(event->services);
							free(event->mqtt_msg_info);
							free(event);
							return -1;
						}


						 JSON *successful_devices = JSON_GetObjectFromObject(paras, SUCCESSFUL_DEVICES);
						int successful_devices_count = JSON_GetArraySize(successful_devices);
						event->services[i].gtw_add_device_paras->successful_devices_count = successful_devices_count;

						event->services[i].gtw_add_device_paras->successful_devices = (EN_IOTA_DEVICE_INFO*)malloc(sizeof(EN_IOTA_DEVICE_INFO) * successful_devices_count);
						int j = 0;
						while(successful_devices_count > 0) {
							 JSON *deviceInfo = JSON_GetObjectFromArray(successful_devices, j);

							char *parent_device_id = JSON_GetStringFromObject(deviceInfo, PARENT_DEVICE_ID, NULL);    //get value of parent_device_id
							event->services[i].gtw_add_device_paras->successful_devices[j].parent_device_id = parent_device_id;

							char *node_id = JSON_GetStringFromObject(deviceInfo, NODE_ID, NULL);    //get value of node_id
							event->services[i].gtw_add_device_paras->successful_devices[j].node_id = node_id;

							char *device_id = JSON_GetStringFromObject(deviceInfo, DEVICE_ID, NULL);    //get value of device_id
							event->services[i].gtw_add_device_paras->successful_devices[j].device_id = device_id;

							char *name = JSON_GetStringFromObject(deviceInfo, NAME, NULL);    //get value of name
							event->services[i].gtw_add_device_paras->successful_devices[j].name = name;

							char *description = JSON_GetStringFromObject(deviceInfo, DESCRIPTION, NULL);    //get value of description
							event->services[i].gtw_add_device_paras->successful_devices[j].description = description;

							char *manufacturer_id = JSON_GetStringFromObject(deviceInfo, MANUFACTURER_ID, NULL);    //get value of manufacturer_id
							event->services[i].gtw_add_device_paras->successful_devices[j].manufacturer_id = manufacturer_id;

							char *model = JSON_GetStringFromObject(deviceInfo, MODEL, NULL);    //get value of model
							event->services[i].gtw_add_device_paras->successful_devices[j].model = model;

							char *product_id = JSON_GetStringFromObject(deviceInfo, PRODUCT_ID, NULL);    //get value of product_id
							event->services[i].gtw_add_device_paras->successful_devices[j].product_id = product_id;

							char *fw_version = JSON_GetStringFromObject(deviceInfo, FW_VERSION, NULL);    //get value of fw_version
							event->services[i].gtw_add_device_paras->successful_devices[j].fw_version = fw_version;

							char *sw_version = JSON_GetStringFromObject(deviceInfo, SW_VERSION, NULL);    //get value of sw_version
							event->services[i].gtw_add_device_paras->successful_devices[j].sw_version = sw_version;

							char *status = JSON_GetStringFromObject(deviceInfo, STATUS, NULL);    //get value of status
							event->services[i].gtw_add_device_paras->successful_devices[j].status = status;

							char *extension_info = JSON_GetStringFromObject(deviceInfo, EXTENSION_INFO, NULL);    //get value of status
							event->services[i].gtw_add_device_paras->successful_devices[j].extension_info = extension_info;

							j++;
							successful_devices_count--;

						}


						 JSON *failed_devices = JSON_GetObjectFromObject(paras, FAILED_DEVICES);
						int failed_devices_count = JSON_GetArraySize(failed_devices);

						event->services[i].gtw_add_device_paras->failed_devices_count = failed_devices_count;

						event->services[i].gtw_add_device_paras->failed_devices = (EN_IOTA_ADD_DEVICE_FAILED_REASON*)malloc(sizeof(EN_IOTA_ADD_DEVICE_FAILED_REASON) * failed_devices_count);
						int k = 0;
						while (failed_devices_count > 0){
							 JSON *reason = JSON_GetObjectFromArray(failed_devices, k);

							char *node_id = JSON_GetStringFromObject(reason, NODE_ID, NULL);    //get value of parent_device_id
							event->services[i].gtw_add_device_paras->failed_devices[k].node_id = node_id;

							char *product_id = JSON_GetStringFromObject(reason, PRODUCT_ID, NULL);    //get value of parent_device_id
							event->services[i].gtw_add_device_paras->failed_devices[k].product_id = product_id;

							char *error_code = JSON_GetStringFromObject(reason, ERROR_CODE, NULL);
							event->services[i].gtw_add_device_paras->failed_devices[k].error_code = error_code;

						    char *error_msg = JSON_GetStringFromObject(reason, ERROR_MSG, NULL);
							event->services[i].gtw_add_device_paras->failed_devices[k].error_msg = error_msg;

							k++;
							failed_devices_count--;
						}
					}

					//the response of gateway deleting a sub device
					if(!strcmp(event_type, DEL_SUB_DEVICE_RESPONSE)) {

						char *event_id = JSON_GetStringFromObject(serviceEvent, EVENT_ID, NULL);    //get value of event_id
						event->services[i].event_id = event_id;
						event->services[i].event_type = EN_IOTA_EVENT_DEL_SUB_DEVICE_RESPONSE;

						event->services[i].gtw_del_device_paras = (EN_IOTA_GTW_DEL_DEVICE_PARAS*)malloc(sizeof(EN_IOTA_GTW_DEL_DEVICE_PARAS));
						if(event->services[i].gtw_del_device_paras == NULL) {
							printf( "HandleEventsDown(): there is not enough memory here.\n");
							free(event->services);
							free(event->mqtt_msg_info);
							free(event);
							return -1;
						}


						 JSON *successful_devices = JSON_GetObjectFromObject(paras, SUCCESSFUL_DEVICES);
						int successful_devices_count = JSON_GetArraySize(successful_devices);
						event->services[i].gtw_del_device_paras->successful_devices_count = successful_devices_count;

						event->services[i].gtw_del_device_paras->successful_devices = (char*)malloc(sizeof(char) * successful_devices_count);
						int j = 0;
						while(successful_devices_count > 0){
							char *device_id = JSON_GetStringFromArray(successful_devices, j, NULL);
							event->services[i].gtw_del_device_paras->successful_devices[j] = device_id;
							j++;
							successful_devices_count--;
						}


						 JSON *failed_devices = JSON_GetObjectFromObject(paras, FAILED_DEVICES);
						int failed_devices_count = JSON_GetArraySize(failed_devices);
						event->services[i].gtw_del_device_paras->failed_devices_count = failed_devices_count;

						event->services[i].gtw_del_device_paras->failed_devices = (EN_IOTA_DEL_DEVICE_FAILED_REASON*)malloc(sizeof(EN_IOTA_DEL_DEVICE_FAILED_REASON) * failed_devices_count);
						int k = 0;
						while(failed_devices_count > 0){
							char *reason = JSON_GetObjectFromArray(failed_devices, k);

							char *device_id = JSON_GetStringFromObject(reason, DEVICE_ID, NULL);
							event->services[i].gtw_del_device_paras->failed_devices[k].device_id = device_id;

							char *error_code = JSON_GetStringFromObject(reason, ERROR_CODE, NULL);
							event->services[i].gtw_del_device_paras->failed_devices[k].error_code = error_code;

						    char *error_msg = JSON_GetStringFromObject(reason, ERROR_MSG, NULL);
							event->services[i].gtw_del_device_paras->failed_devices[k].error_msg = error_msg;
							k++;
							failed_devices_count--;
						}
					}
				}

				//OTA
				if (!strcmp(service_id, OTA)) {

					event->services[i].servie_id = EN_IOTA_EVENT_OTA;
					event->services[i].ota_paras = (EN_IOTA_OTA_PARAS*)malloc(sizeof(EN_IOTA_OTA_PARAS));
					if (event->services[i].ota_paras == NULL) {
						printf( "HandleEventsDown(): there is not enough memory here.\n");
						free(event->services);
						free(event->mqtt_msg_info);
						free(event);
						return -1;
					}

					if (!strcmp(event_type, VERSION_QUERY)){
						event->services[i].event_type = EN_IOTA_EVENT_VERSION_QUERY;
					} else if (!strcmp(event_type, FIRMWARE_UPGRADE)) {
						event->services[i].event_type = EN_IOTA_EVENT_FIRMWARE_UPGRADE;
					} else if (!strcmp(event_type, SOFTWARE_UPGRADE)) {
						event->services[i].event_type = EN_IOTA_EVENT_SOFTWARE_UPGRADE;
					}

					//firmware_upgrade or software_upgrade
					if (event->services[i].event_type == EN_IOTA_EVENT_FIRMWARE_UPGRADE || event->services[i].event_type == EN_IOTA_EVENT_SOFTWARE_UPGRADE) {
						char *version = JSON_GetStringFromObject(paras, VERSION, NULL);    //get value of version
						event->services[i].ota_paras->version = version;

						char *url = JSON_GetStringFromObject(paras, URL, NULL);    //get value of url
						event->services[i].ota_paras->url = url;

						int file_size = JSON_GetIntFromObject(paras, FILE_SIZE, -1);    //get value of file_size
						event->services[i].ota_paras->file_size = file_size;

						char *access_token = JSON_GetStringFromObject(paras, ACCESS_TOKEN, NULL);    //get value of access_token
						event->services[i].ota_paras->access_token = access_token;

						int expires = JSON_GetIntFromObject(paras, EXPIRES, -1);    //get value of expires
						event->services[i].ota_paras->expires = expires;

						char *sign = JSON_GetStringFromObject(paras, SIGN, NULL);    //get value of sign
						event->services[i].ota_paras->sign = sign;

					}

				}

				//NTP
				if (!strcmp(service_id, SDK_TIME)) {
					event->services[i].servie_id = EN_IOTA_EVENT_TIME_SYNC;
					event->services[i].ntp_paras = (EN_IOTA_NTP_PARAS*)malloc(sizeof(EN_IOTA_NTP_PARAS));

					if (!strcmp(event_type, TIME_SYNC_RSP)){
						event->services[i].event_type = EN_IOTA_EVENT_GET_TIME_SYNC_RESPONSE;

						long long device_send_time = getLLongValueFromStr(message, DEVICE_SEND_TIME_JSON);
						long long server_recv_time = getLLongValueFromStr(message, SERVER_RECV_TIME_JSON);
						long long server_send_time = getLLongValueFromStr(message, SERVER_SEND_TIME_JSON);
						event->services[i].ntp_paras->device_real_time = (server_recv_time + server_send_time + getTime() - device_send_time) / 2;
					}

				}

				//device log
				if (!strcmp(service_id, LOG)) {
					event->services[i].servie_id = EN_IOTA_EVENT_DEVICE_LOG;
					event->services[i].device_log_paras = (EN_IOTA_DEVICE_LOG_PARAS*)malloc(sizeof(EN_IOTA_DEVICE_LOG_PARAS));

					if (!strcmp(event_type, LOG_CONFIG)) {
						event->services[i].event_type = EN_IOTA_EVENT_LOG_CONFIG;

						char *log_switch = JSON_GetStringFromObject(paras, SWITCH, NULL);
						event->services[i].device_log_paras->log_switch = log_switch;

						char *end_time = JSON_GetStringFromObject(paras, END_TIME, NULL);
						event->services[i].device_log_paras->end_time = end_time;

					}

				}

			}

			i++;
			services_count--;
		}

		if (onEventDown) {
			(onEventDown)(event);
		}

		JSON_Delete(root);

		if (event != NULL) {
			int m;
			for (m = 0;m < services_count_copy;m++) {
				if (event->services[m].servie_id == EN_IOTA_EVENT_SUB_DEVICE_MANAGER) {

					if((event->services[m].event_type == EN_IOTA_EVENT_DELETE_SUB_DEVICE_NOTIFY) || (event->services[m].event_type == EN_IOTA_EVENT_ADD_SUB_DEVICE_NOTIFY)) {
						MemFree(&event->services[m].paras->devices);
						MemFree(&event->services[m].paras);
					} else if (event->services[m].event_type == EN_IOTA_EVENT_ADD_SUB_DEVICE_RESPONSE){

						MemFree(&event->services[m].gtw_add_device_paras->successful_devices);
						MemFree(&event->services[m].gtw_add_device_paras->failed_devices);
						MemFree(&event->services[m].gtw_add_device_paras);
					} else if (event->services[m].event_type == EN_IOTA_EVENT_DEL_SUB_DEVICE_RESPONSE){
						MemFree(&event->services[m].gtw_del_device_paras->successful_devices);
						MemFree(&event->services[m].gtw_del_device_paras->failed_devices);
						MemFree(&event->services[m].gtw_del_device_paras);
					}
				} else if (event->services[m].servie_id == EN_IOTA_EVENT_OTA) {
					MemFree(&event->services[m].ota_paras);
				} else if (event->services[m].servie_id == EN_IOTA_EVENT_TIME_SYNC) {
					MemFree(&event->services[m].ntp_paras);
				} else if (event->services[m].servie_id == EN_IOTA_EVENT_DEVICE_LOG) {
					MemFree(&event->services[m].device_log_paras);
				}
			}

			MemFree(&event->services);
			MemFree(&event->mqtt_msg_info);
			MemFree(&event);
		}

		return 0;
	
}
int oc_mqtt_comm_bs(void *context, int token, int code, char *message){
    EN_IOTA_MQTT_PROTOCOL_RSP *bootstrap_msg  = (EN_IOTA_MQTT_PROTOCOL_RSP*)malloc(sizeof(EN_IOTA_MQTT_PROTOCOL_RSP));
		if (bootstrap_msg == NULL) {
			printf( "OnMessageArrived(): there is not enough memory here.\n");
			return -1;
		}
		bootstrap_msg->mqtt_msg_info = (EN_IOTA_MQTT_MSG_INFO*)malloc(sizeof(EN_IOTA_MQTT_MSG_INFO));
		if (bootstrap_msg->mqtt_msg_info == NULL) {
			printf( "OnMessageArrived(): there is not enough memory here.\n");
			free(bootstrap_msg);
			return -1;
		}
		bootstrap_msg->mqtt_msg_info->context = context;
		bootstrap_msg->mqtt_msg_info->messageId = token;
		bootstrap_msg->mqtt_msg_info->code = code;

		 JSON *root = JSON_Parse(message);
		bootstrap_msg->message = JSON_GetStringFromObject(root, ADDRESS, "-1");
		if (onBootstrap) {
			(onBootstrap)(bootstrap_msg);
		}

		JSON_Delete(root);
		MemFree(&bootstrap_msg->mqtt_msg_info);
		MemFree(&bootstrap_msg);

		return 0;
}
int oc_mqtt_comm_last(void *context, int token, int code, char *message){

}

int oc_mqtt_profile_rcvdeal(oc_mqtt_profile_msgrcv_t *payload)
{
    printf("oc_mqtt_profile_rcvdeal msg = %s\n", payload->msg);
    int ret = 0;
    switch (payload->type)
    {
    case EN_OC_MQTT_PROFILE_MSG_TYPE_DOWN_MSGDOWN:
        ret = oc_mqtt_comm_msgdown(NULL, 0, 0, payload->msg);
        break;
    case EN_OC_MQTT_PROFILE_MSG_TYPE_DOWN_COMMANDS:
        ret = oc_mqtt_comm_commands(NULL, 0, 0, payload->request_id,payload->msg);   
        break;
    case EN_OC_MQTT_PROFILE_MSG_TYPE_DOWN_PROPERTYSET:
        ret = oc_mqtt_comm_propertyset(NULL, 0, 0, payload->request_id, payload->msg);     
        break;
    case EN_OC_MQTT_PROFILE_MSG_TYPE_DOWN_PROPERTYGET:
        ret = oc_mqtt_comm_propertyget(NULL, 0, 0, payload->request_id,payload->msg); 
        break;
    case EN_OC_MQTT_PROFILE_MSG_TYPE_DOWN_EVENT:
        ret = oc_mqtt_comm_event(NULL, 0, 0, payload->msg); 
        break;
    case EN_OC_MQTT_PROFILE_MSG_TYPE_DOWN_BS:
        ret = oc_mqtt_comm_bs(NULL, 0, 0, payload->msg);
        break;
    case EN_OC_MQTT_PROFILE_MSG_TYPE_DOWN_LAST:
        ret = oc_mqtt_comm_last(NULL, 0, 0, payload->msg);
        break;
    default:
        ret = -1;
        break;
    }

    return ret;
}

int SetEventCallback(EVENT_CALLBACK_HANDLER pfnCallbackHandler) {
	onEventDown = pfnCallbackHandler;
}

int SetCmdCallback(CMD_CALLBACK_HANDLER pfnCallbackHandler) {
	onCmd = pfnCallbackHandler;
}

int SetMessageCallback(MESSAGE_CALLBACK_HANDLER pfnCallbackHandler) {
	onMessage = pfnCallbackHandler;
}

int SetPropSetCallback(PROP_SET_CALLBACK_HANDLER pfnCallbackHandler) {
	onPropertiesSet = pfnCallbackHandler;
}

int SetPropGetCallback(PROP_GET_CALLBACK_HANDLER pfnCallbackHandler) {
	onPropertiesGet = pfnCallbackHandler;
}

int SetBootstrapCallback(BOOTSTRAP_CALLBACK_HANDLER pfnCallbackHandler) {
	onBootstrap = pfnCallbackHandler;
}

